#!/bin/sh

DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
DPLY_PAGE_SB_INTERNET_CONN_RESULT_OK=0
DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR=1

DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=${DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR}
DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0


dply_page_internet_enable_on_off() {
	case ${1} in
		$DPLY_PAGE_SB_INTERNET_CONN_ITEM_1) # 'Enable'
			[ "$RT_NAT_INTERNET_CONN" == "0" ] && echo off || echo on
		;;
		$DPLY_PAGE_SB_INTERNET_CONN_ITEM_2) # 'Disable'
			[ "$RT_NAT_INTERNET_CONN" == "0" ] && echo on || echo off
		;;
		*) echo off ;;
	esac
}


dply_page_sb_internet_conn() {
	debug_print "in function '${FUNCNAME[0]}'"
    
	[ -z "${RT_NAT_INTERNET_CONN}" ] && RT_NAT_INTERNET_CONN="${conf_nat_internet_conn}"
    local list="\"${DPLY_PAGE_SB_INTERNET_CONN_ITEM1}\" \"\" `[ $RT_NAT_INTERNET_CONN -eq 0 ] && echo off || echo on`"
    
	local item_number=2
	local radio_list=""
	for (( i=1; i<=$item_number; i=i+1 ))
	do
			eval radio_item=\$DPLY_PAGE_SB_INTERNET_CONN_ITEM_$i
			radio_list="$radio_list \"$radio_item\" \"\" `dply_page_internet_enable_on_off "$radio_item"`"
	done

    tp_radiolist \
        "${DPLY_PAGE_SB_INTERNET_CONN_TITLE}" \
        "${DPLY_PAGE_SB_INTERNET_CONN_TEXT}" \
        "${DPLY_PAGE_SB_INTERNET_CONN_LABEL_OK}" \
        "${DPLY_PAGE_SB_INTERNET_CONN_LABEL_CANCEL}" \
        "${radio_list}" \
		$item_number

    debug_print "TP_CHECKLIST_OK_CANCEL_RESULT_CODE: ${TP_CHECKLIST_OK_CANCEL_RESULT_CODE}"
    case "${TP_RADIOLIST_RESULT_CODE}" in
    
        "${TP_RADIOLIST_RESULT_ERROR}" )
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${TP_CHECKLIST_OK_CANCEL_RESULT_MSG}"
            return
            ;;
        
        "${TP_RADIOLIST_RESULT_CANCEL}" )
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_OK
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            return
            ;;
            
        "${TP_RADIOLIST_RESULT_OK}" )
            ;;
            
        * )
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    debug_print "TP_RADIOLIST_RESULT_SELECT: ${TP_RADIOLIST_RESULT_SELECT}"
	case "${TP_RADIOLIST_RESULT_SELECT}" in
    
        $DPLY_PAGE_SB_INTERNET_CONN_ITEM_1 )
			RT_NAT_INTERNET_CONN="1"
            ;;
        
        $DPLY_PAGE_SB_INTERNET_CONN_ITEM_2 )
			RT_NAT_INTERNET_CONN="0"
            ;;
            
        * )
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_UNKNOWN}"
            return
            ;;
    esac

    debug_print "RT_NAT_INTERNET_CONN: ${RT_NAT_INTERNET_CONN}"
    utility_save_nat_internet_conn_conf \
        "${RT_NAT_INTERNET_CONN}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
        DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
        DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_SAVE_CONFIGURATION}"
        return
    fi
    
    case "${RT_NAT_INTERNET_CONN}" in
        0 )
            debug_print "DisableSBInternetConnection...."
            
            utility_apply_nat_network_conf_isolated
            if [ "${?}" -ne 0 ]; then
                DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
                DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
                DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_ISOLATE}: ${UTILITY_APPLY_NAT_NETWORK_CONF_ISOLATED_RESULT_MSG}"
                return
            fi

            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=3
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
        1 )
            debug_print "EnableSBInternetConnection... "
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_ESXI_INFO_CONF_RESULT_OK
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=1
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
        * )
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_CODE=$DPLY_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            DPLY_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_UNKNOWN}"
            ;;
    esac
}
